/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.client;

import com.ibm.hsc.rep.client.CIMClassCache;
import com.ibm.hsc.rep.client.RClientObjectId;
import com.ibm.hsc.rep.client.RClientUtils;
import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;

public class RClientObject
implements RSerializableInterface {
    private String mNameSpace;
    private String mClassName;
    private Hashtable mPropHash = new Hashtable();
    private Vector mKeyVec = new Vector();
    private static Error sNULL = new Error();

    public RClientObject() {
    }

    public RClientObject(String string, CIMInstance cIMInstance) {
        this.mNameSpace = string;
        this.mClassName = cIMInstance.getClassName();
        Vector vector = cIMInstance.getProperties();
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
            Object object = RClientUtils.getRValue(cIMProperty);
            this.setProperty(cIMProperty.getName(), object);
        }
    }

    public void loadObject(RSerializableObject rSerializableObject) {
        Vector vector = (Vector)rSerializableObject.getObject();
        int n = vector.size();
        this.mNameSpace = (String)vector.elementAt(0);
        this.mClassName = (String)vector.elementAt(1);
        for (int i = 2; i < n; ++i) {
            RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(i);
            this.setProperty(rSerializableProperty.getName(), rSerializableProperty.getRValue());
            if (!rSerializableProperty.isKey()) continue;
            this.mKeyVec.add(rSerializableProperty.getName());
        }
    }

    public Object writeReplace() {
        Object object;
        String string = "com.ibm.hsc.rep.RObject";
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNameSpace);
        vector.add(this.mClassName);
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Object object2 = this.getProperty((String)object);
            boolean bl = false;
            if (this.mKeyVec.contains(object)) {
                bl = true;
            }
            RSerializableProperty rSerializableProperty = new RSerializableProperty(bl, (String)object, object2);
            vector.add(rSerializableProperty);
        }
        object = new RSerializableObject(string, null, vector);
        return object;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public Hashtable getAllProperties() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.mPropHash.get(k);
            if (v instanceof Error) continue;
            hashtable.put(k, v);
        }
        return hashtable;
    }

    public Object getProperty(String string) {
        Object v = this.mPropHash.get(string);
        if (v instanceof Error) {
            return null;
        }
        return v;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            this.mPropHash.put(string, sNULL);
        } else {
            this.mPropHash.put(string, object);
        }
    }

    public RClientObjectId getObjectId() {
        RClientObjectId rClientObjectId = new RClientObjectId(this.mNameSpace, this.mClassName);
        for (int i = 0; i < this.mKeyVec.size(); ++i) {
            String string = (String)this.mKeyVec.elementAt(i);
            rClientObjectId.setKey(string, this.getProperty(string));
        }
        return rClientObjectId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("instance of ");
        stringBuffer.append(this.mClassName);
        stringBuffer.append(" {\n");
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getProperty(string);
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray != null) {
                    Vector<Object> vector = new Vector<Object>();
                    for (int i = 0; i < objectArray.length; ++i) {
                        vector.add(objectArray[i]);
                    }
                    stringBuffer.append(vector);
                } else {
                    stringBuffer.append("null");
                }
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public CIMInstance getCIMInstance(CIMClient cIMClient) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.mClassName, this.mNameSpace);
        CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false);
        return this.getCIMInstance(cIMClass);
    }

    public CIMInstance getCIMInstance(CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.mClassName, this.mNameSpace);
        cIMInstance = cIMClass.newInstance();
        Vector vector = cIMInstance.getProperties();
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
            String string = cIMProperty.getName();
            CIMDataType cIMDataType = cIMProperty.getType();
            Object object = null;
            object = this.getProperty(string);
            CIMValue cIMValue = null;
            if (object != null) {
                cIMValue = new CIMValue(object, cIMDataType);
            }
            cIMProperty.setValue(cIMValue);
        }
        return cIMInstance;
    }

    public CIMInstance getCIMInstance(String string, String string2, String string3) throws CIMException {
        CIMClass cIMClass = CIMClassCache.getInstance().getCIMClass(this.mNameSpace, string, string2, string3, this.mClassName);
        return this.getCIMInstance(cIMClass);
    }

    public Hashtable getChangedProperties(RClientObject rClientObject, boolean bl) {
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
        Hashtable hashtable2 = rClientObject.mPropHash;
        Enumeration enumeration = this.mPropHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.mPropHash.get(string);
            Object v2 = hashtable2.get(string);
            if (null == v && null == v2 || v.equals(v2)) continue;
            if (bl) {
                if (v instanceof UnsignedInt8) {
                    short s = ((UnsignedInt8)v).shortValue();
                    hashtable.put(string, new Short(s));
                    continue;
                }
                if (v instanceof UnsignedInt16) {
                    int n = ((UnsignedInt16)v).intValue();
                    hashtable.put(string, new Integer(n));
                    continue;
                }
                if (v instanceof UnsignedInt32) {
                    long l = ((UnsignedInt32)v).longValue();
                    hashtable.put(string, new Long(l));
                    continue;
                }
                hashtable.put(string, (Number)v);
                continue;
            }
            hashtable.put(string, (Number)v);
        }
        return hashtable;
    }

    public String getKey(String string) throws Exception {
        String string2 = null;
        if (string.equals("IBMHSC_Frame")) {
            string2 = this.mPropHash.get("Name") + "~" + this.mPropHash.get("CreationClassName") + "~";
        } else if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
            string2 = this.mPropHash.get("Name") + "~" + this.mPropHash.get("CreationClassName") + "~";
        } else if (string.equals("IBMHSC_Partition")) {
            string2 = this.mPropHash.get("Name") + "~" + this.mPropHash.get("CreationClassName") + "~";
        } else if (string.equals("IBMHSC_LparProfile")) {
            string2 = this.mPropHash.get("PartitionName") + "~" + this.mPropHash.get("PartitionCreationClassName") + "~" + this.mPropHash.get("SettingID") + "~";
        } else if (string.equals("IBMHSC_SystemProfile")) {
            string2 = this.mPropHash.get("SystemName") + "~" + this.mPropHash.get("SystemCreationClassName") + "~" + this.mPropHash.get("CreationClassName") + "~" + this.mPropHash.get("Name") + "~";
        } else {
            System.err.println("invalid object class: " + string);
            throw new Exception("invalid object class: " + string);
        }
        return string2;
    }
}

